<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title><?php echo e(get_option('site_title', config('app.name'))); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        
		<!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(get_favicon()); ?>">

		<!-- DataTables -->
        <link href="<?php echo e(asset('public/backend/plugins/datatable/datatables.min.css')); ?>" rel="stylesheet" type="text/css" /> 

		<link href="<?php echo e(asset('public/backend/plugins/dropify/css/dropify.min.css')); ?>" rel="stylesheet">
		<link href="<?php echo e(asset('public/backend/plugins/sweet-alert2/css/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css">
        <link href="<?php echo e(asset('public/backend/plugins/animate/animate.css')); ?>" rel="stylesheet" type="text/css">
		<link href="<?php echo e(asset('public/backend/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet" type="text/css" />
		<link href="<?php echo e(asset('public/backend/plugins/daterangepicker/daterangepicker.css')); ?>" rel="stylesheet" />
	    <link href="<?php echo e(asset('public/backend/plugins/jquery-toast-plugin/jquery.toast.min.css')); ?>" rel="stylesheet" />
        
		<!-- App Css -->
        <link rel="stylesheet" href="<?php echo e(asset('public/backend/plugins/bootstrap/css/bootstrap.min.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('public/backend/assets/css/fontawesome.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('public/backend/assets/css/themify-icons.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('public/backend/plugins/metisMenu/metisMenu.css')); ?>">
		
		<!-- Others css -->
		<link rel="stylesheet" href="<?php echo e(asset('public/backend/assets/css/typography.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('public/backend/assets/css/default-css.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('public/backend/assets/css/styles.css') . '?v=' . filemtime(public_path('backend/assets/css/styles.css'))); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('public/backend/assets/css/responsive.css?v=1.0')); ?>">
		
		<!-- Modernizr -->
		<script src="<?php echo e(asset('public/backend/assets/js/vendor/modernizr-3.6.0.min.js')); ?>"></script>     

		<?php if(get_option('backend_direction') == "rtl"): ?>
			<link rel="stylesheet" href="<?php echo e(asset('public/backend/plugins/bootstrap/css/bootstrap-rtl.min.css')); ?>">
			<link rel="stylesheet" href="<?php echo e(asset('public/backend/assets/css/rtl/style.css?v=1.0')); ?>">
		<?php endif; ?>
		
		<?php echo $__env->make('layouts.others.languages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
    </head>

    <body>  
		<!-- Main Modal -->
		<div id="main_modal" class="modal" tabindex="-1" role="dialog">
		    <div class="modal-dialog modal-lg" role="document">
				<div class="modal-content">
				    <div class="modal-header bg-primary">
						<h5 class="modal-title mt-0 text-white"></h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						  <i class="ti-close text-white"></i>
						</button>
				    </div>
				  
				    <div class="alert alert-danger d-none mx-4 mt-3 mb-0"></div>
				    <div class="alert alert-primary d-none mx-4 mt-3 mb-0"></div>			  
				    <div class="modal-body overflow-hidden"></div>
				  
				</div>
		    </div>
		</div>
		
		<!-- Secondary Modal -->
		<div id="secondary_modal" class="modal" tabindex="-1" role="dialog">
		    <div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
				    <div class="modal-header bg-dark">
						<h5 class="modal-title mt-0 text-white"></h5>
						<button type="button" class="close" data-dismiss="modal" aria-label="Close">
							<i class="ti-close text-white"></i>
						</button>
				    </div>
				  
				    <div class="alert alert-danger d-none mx-4 mt-3 mb-0"></div>
				    <div class="alert alert-primary d-none mx-4 mt-3 mb-0"></div>			  
				    <div class="modal-body overflow-hidden"></div>
				</div>
		    </div>
		</div>
	     
		<!-- Preloader area start -->
		<div id="preloader"></div>
		<!-- Preloader area end -->
		
		<div class="page-container">
		    <!-- sidebar menu area start -->
			<div class="sidebar-menu">
				
				<div class="sidebar-header text-center">
					<a href="<?php echo e(route('dashboard.index')); ?>"><img src="<?php echo e(get_logo()); ?>" class="company-logo" alt="logo"></a>			
				</div>
				
				<div class="user-details">
					<img class="avatar" src="<?php echo e(profile_picture()); ?>" alt="avatar">
					<span class="text-white d-inline-block"><?php echo e(Auth::user()->name); ?> </span><br>
				</div>
				
				<div class="main-menu">
					<div class="menu-inner">
						<nav>
							<ul class="metismenu" id="menu">
								<?php echo $__env->make('layouts.menus.'.Auth::user()->user_type, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
							</ul>
						</nav>
					</div>
				</div>
			</div>
			<!-- sidebar menu area end -->
        
			<!-- main content area start -->
			<div class="main-content">

				<!-- header area start -->
				<div class="header-area">
					<div class="row align-items-center">
						<!-- nav and search button -->
						<div class="col-lg-6 col-4 clearfix rtl-2">
							<div class="nav-btn float-left">
								<span></span>
								<span></span>
								<span></span>
							</div>
						</div>

						<!-- profile info & task notification -->
						<div class="col-lg-6 col-8 clearfix rtl-1">

							<ul class="notification-area float-right">
	                            <li class="d-none d-md-inline-block">
									<div class="dropdown">
									  <a class="dropdown-toggle" type="button" id="selectLanguage" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									  	<?php echo e(session('language') =='' ? get_option('language') : session('language')); ?>

										<i class="fa fa-angle-down"></i>
									  </a>
									  <div class="dropdown-menu" aria-labelledby="selectLanguage">
										<?php $__currentLoopData = get_language_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<a class="dropdown-item" href="<?php echo e(route('switch_language')); ?>?language=<?php echo e($language); ?>"><?php echo e($language); ?></a>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									  </div>
									</div>
								</li>

								<?php if(Auth::user()->user_type == 'customer'): ?>
									<?php $notificatioCount = Auth::user()->member->unreadNotifications->count(); ?>
									<li class="dropdown d-none d-sm-inline-block">
										<i class="ti-bell dropdown-toggle" data-toggle="dropdown">
											<span><?php echo e($notificatioCount); ?></span>
										</i>
										<div class="dropdown-menu bell-notify-box notify-box">
											<span class="notify-title"><?php echo e(_lang('You have').' '.$notificatioCount.' '._lang('new notifications')); ?></span>
											<div class="nofity-list">
												<?php $__currentLoopData = Auth::user()->member->notifications->take(15); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<a href="<?php echo e(route('profile.show_notification', $notification->id)); ?>" class="ajax-modal-2 notify-item <?php echo e($notification->read_at == null ? 'unread-notification' : ''); ?>" data-title="<?php echo e(_lang('Notification Details')); ?>">	
														<div class="notify-thumb">
															<img src="<?php echo e(profile_picture()); ?>">
														</div>
														<div class="notify-text">
															<span><?php echo e($notification->data['message']); ?></span><br>
															<span><?php echo e($notification->created_at->diffForHumans()); ?></span>
														</div>
													</a>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</div>
										</div>
									</li>
								<?php endif; ?>
								
								<li>
									<div class="user-profile">
										<h4 class="user-name dropdown-toggle" data-toggle="dropdown">
											<img class="avatar user-thumb" id="my-profile-img" src="<?php echo e(profile_picture()); ?>" alt="avatar"> <?php echo e(Auth::user()->name); ?> <i class="fa fa-angle-down"></i>
										</h4>
										<div class="dropdown-menu">
											<?php if(auth()->user()->user_type == 'customer'): ?>
											<a class="dropdown-item" href="<?php echo e(route('profile.membership_details')); ?>"><i class="ti-user text-muted mr-2"></i>&nbsp;<?php echo e(_lang('Membership Details')); ?></a>
											<?php endif; ?>
											<a class="dropdown-item" href="<?php echo e(route('profile.edit')); ?>"><i class="ti-pencil text-muted mr-2"></i>&nbsp;<?php echo e(_lang('Profile Settings')); ?></a>
											<a class="dropdown-item" href="<?php echo e(route('profile.change_password')); ?>"><i class="ti-exchange-vertical text-muted mr-2"></i></i>&nbsp;<?php echo e(_lang('Change Password')); ?></a>
											<?php if(auth()->user()->user_type == 'admin'): ?>
											<a class="dropdown-item" href="<?php echo e(route('settings.update_settings')); ?>"><i class="ti-settings text-muted mr-2"></i>&nbsp;<?php echo e(_lang('System Settings')); ?></a>
											<?php endif; ?>
											<div class="dropdown-divider"></div>
											<a class="dropdown-item" href="<?php echo e(route('logout')); ?>"><i class="ti-power-off text-muted mr-2"></i>&nbsp;<?php echo e(_lang('Logout')); ?></a>
										</div>
									</div>
	                            </li>
	                            
	                        </ul>

						</div>
					</div>
				</div><!-- header area end -->
				
				<!-- page title area start -->
				<?php if(Request::is('dashboard')): ?>
				<div class="page-title-area mb-3">
					<div class="row align-items-center py-3">
						<div class="col-sm-12">
							<div class="breadcrumbs-area clearfix">
								<h6 class="page-title float-left"><?php echo e(_lang('Dashboard')); ?></h6>
								
								<!--Branch Switcher-->
								<?php if(auth()->user()->user_type == 'admin' || auth()->user()->all_branch_access == 1): ?>
								<div class="dropdown float-right">
									<a class="dropdown-toggle btn btn-dark btn-xs" type="button" id="selectLanguage" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<?php echo e(session('branch') =='' ? _lang('All Branch') : session('branch')); ?>

									</a>
									<div class="dropdown-menu" aria-labelledby="selectLanguage">
									<a class="dropdown-item" href="<?php echo e(route('switch_branch')); ?>"><?php echo e(_lang('All Branch')); ?></a>
									<a class="dropdown-item" href="<?php echo e(route('switch_branch')); ?>?branch_id=default&branch=<?php echo e(get_option('default_branch_name', 'Main Branch')); ?>"><?php echo e(get_option('default_branch_name', 'Main Branch')); ?></a>
									<?php $__currentLoopData = \App\Models\Branch::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<a class="dropdown-item" href="<?php echo e(route('switch_branch')); ?>?branch_id=<?php echo e($branch->id); ?>&branch=<?php echo e($branch->name); ?>"><?php echo e($branch->name); ?></a>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</div>
								</div>
								<?php endif; ?>
								<!--<?php echo $__env->make('layouts.others.breadcrumbs', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>-->
							</div>
						</div>
					</div>
				</div><!-- page title area end -->
				<?php endif; ?>
				
				<div class="main-content-inner <?php echo e(! Request::is('dashboard') ? 'mt-4' : ''); ?>">		
					<div class="row">
						<div class="<?php echo e(isset($alert_col) ? $alert_col : 'col-lg-12'); ?>">
							<div class="alert alert-success alert-dismissible" id="main_alert" role="alert">
								<button type="button" id="close_alert" class="close">
									<span aria-hidden="true"><i class="far fa-times-circle"></i></span>
								</button>
								<span class="msg"></span>
							</div>
						</div>
					</div>
                    
					<?php echo $__env->yieldContent('content'); ?>
				</div><!--End main content Inner-->
				
			</div><!--End main content-->

		</div><!--End Page Container-->

        <!-- jQuery  -->
		<script src="<?php echo e(asset('public/backend/assets/js/vendor/jquery-3.6.1.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/assets/js/popper.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/metisMenu/metisMenu.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/slimscroll/jquery.slimscroll.min.js')); ?>"></script>
        
		<script src="<?php echo e(asset('public/backend/assets/js/print.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/pace/pace.min.js')); ?>"></script>
        <script src="<?php echo e(asset('public/backend/plugins/moment/moment.js')); ?>"></script>
		
		<!-- Datatable js -->
        <script src="<?php echo e(asset('public/backend/plugins/datatable/datatables.min.js')); ?>"></script>
        
		<script src="<?php echo e(asset('public/backend/plugins/dropify/js/dropify.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/sweet-alert2/js/sweetalert2.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/select2/js/select2.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/tinymce/tinymce.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/parsleyjs/parsley.min.js')); ?>"></script>
		<script src="<?php echo e(asset('public/backend/plugins/jquery-toast-plugin/jquery.toast.min.js')); ?>"></script>

        <!-- App js -->
        <script src="<?php echo e(asset('public/backend/assets/js/scripts.js') . '?v=' . filemtime(public_path('backend/assets/js/scripts.js'))); ?>"></script>

		<script type="text/javascript">		
		(function($) {

    		"use strict";		
			
			//Show Success Message
			<?php if(Session::has('success')): ?>
		       $("#main_alert > span.msg").html(" <?php echo e(session('success')); ?> ");
			   $("#main_alert").addClass("alert-success").removeClass("alert-danger");
			   $("#main_alert").css('display','block');
			<?php endif; ?>
			
			//Show Single Error Message
			<?php if(Session::has('error')): ?>
			   $("#main_alert > span.msg").html(" <?php echo e(session('error')); ?> ");
			   $("#main_alert").addClass("alert-danger").removeClass("alert-success");
			   $("#main_alert").css('display','block');
			<?php endif; ?>
			
			
			<?php $i = 0; ?>

			<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			    <?php if($loop->first): ?>
					$("#main_alert > span.msg").html("<i class='ti-alert'></i>&nbsp;<?php echo e($error); ?> ");
					$("#main_alert").addClass("alert-danger").removeClass("alert-success");
				<?php else: ?>
                    $("#main_alert > span.msg").append("<br><i class='ti-alert'></i>&nbsp;<?php echo e($error); ?> ");					
				<?php endif; ?>
				
				<?php if($loop->last): ?>
					$("#main_alert").css('display','block');
				<?php endif; ?>
				
				<?php if(isset($errors->keys()[$i])): ?>
					var name = "<?php echo e($errors->keys()[$i]); ?>";
				
					$("input[name='" + name + "']").addClass('error is-invalid');
					$("select[name='" + name + "'] + span").addClass('error is-invalid');
				
					$("input[name='"+name+"'], select[name='"+name+"']").parent().append("<span class='v-error'><?php echo e($error); ?></span>");
				<?php endif; ?>
				<?php $i++; ?>
			
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			
        })(jQuery);
		
	 </script>
	 
	 <!-- Custom JS -->
	 <?php echo $__env->yieldContent('js-script'); ?>

	 <?php echo $__env->yieldPushContent('scripts'); ?>
		
    </body>
</html><?php /**PATH /Volumes/Development/Sites/credit-lite/resources/views/layouts/app.blade.php ENDPATH**/ ?>