<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="header-title"><?php echo e(_lang('Update Translations')); ?></span>
			</div>
			<div class="card-body">
				<form method="post" id="language-form" class="validate" autocomplete="off" action="<?php echo e(route('languages.update', $id)); ?>">
					<?php echo csrf_field(); ?>
					<input name="_method" type="hidden" value="PATCH">
					<div class="row">
						<?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(ucwords($key)); ?></label>
								<input type="text" class="form-control language-field" name="language[<?php echo e(str_replace(' ','_',$key)); ?>]" value="<?php echo e($lang); ?>" required>
							</div>
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

						<div class="col-md-12">
							<div class="form-group">
								<button type="submit" class="btn btn-primary submit-btn"><i class="ti-check-box"></i>&nbsp;<?php echo e(_lang('Save Translation')); ?></button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
	"use strict";

	$(document).on('submit', '#language-form', function(e){
		e.preventDefault();

		var actionUrl = $(this).attr('action');
		var form = $(this);

		$.ajax({
			method: "POST",
			url: actionUrl,
			data: $.param($(form).serializeArray().slice(0, 990)),
			success: function(data) {

				var secondBatchData = $(form).serializeArray().slice(990);
				if(secondBatchData.length > 0){
					secondBatchData.push({name: '_method', value: 'PATCH'});
					secondBatchData.push({name: '_token', value: $('meta[name="csrf-token"]').attr('content')});

					setTimeout(function() {
						$.ajax({
							method: "POST",
							url: actionUrl,
							data: $.param(secondBatchData),
							success: function(data) {
								var json = JSON.parse(JSON.stringify(data));

								Swal.fire({
									text: json['message'],
									icon: json['result'],
									confirmButtonText: "<?php echo e(_lang('Close')); ?>",
								});
								$(".submit-btn").prop('disabled', false);
							}
						});
					}, 500);
				}else{
					var json = JSON.parse(JSON.stringify(data));

					Swal.fire({
						text: json['message'],
						icon: json['result'],
						confirmButtonText: "<?php echo e(_lang('Close')); ?>",
					});
					$(".submit-btn").prop('disabled', false);
				}
			}
		});
	});

})(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/administration/language/edit.blade.php ENDPATH**/ ?>