DROP TABLE IF EXISTS bank_accounts;

CREATE TABLE `bank_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `opening_date` date NOT NULL,
  `bank_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `opening_balance` decimal(10,2) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_accounts_currency_id_foreign` (`currency_id`),
  CONSTRAINT `bank_accounts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS bank_transactions;

CREATE TABLE `bank_transactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `trans_date` date NOT NULL,
  `bank_account_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `dr_cr` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'deposit | withdraw | transfer',
  `cheque_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_transactions_bank_account_id_foreign` (`bank_account_id`),
  CONSTRAINT `bank_transactions_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS branches;

CREATE TABLE `branches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `descriptions` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS charge_limits;

CREATE TABLE `charge_limits` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `minimum_amount` decimal(18,2) NOT NULL,
  `maximum_amount` decimal(18,2) NOT NULL,
  `fixed_charge` decimal(10,2) NOT NULL,
  `charge_in_percentage` decimal(10,2) NOT NULL,
  `gateway_id` bigint NOT NULL,
  `gateway_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO charge_limits VALUES('1','5000.00','500000.00','0.00','0.00','1','App\\Models\\WithdrawMethod','2025-05-18 08:49:23','2025-05-18 08:49:23');



DROP TABLE IF EXISTS currency;

CREATE TABLE `currency` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` decimal(10,6) NOT NULL,
  `base_currency` tinyint NOT NULL DEFAULT '0',
  `status` tinyint NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO currency VALUES('1','MWK','1.000000','1','1','','2025-05-18 08:40:04');



DROP TABLE IF EXISTS custom_fields;

CREATE TABLE `custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `field_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_value` text COLLATE utf8mb4_unicode_ci,
  `field_width` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `max_size` int DEFAULT NULL,
  `is_required` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'nullable',
  `table` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `allow_for_signup` tinyint NOT NULL DEFAULT '0',
  `allow_to_list_view` tinyint NOT NULL DEFAULT '0',
  `status` tinyint NOT NULL DEFAULT '0',
  `order` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS database_backups;

CREATE TABLE `database_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `file` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS deposit_methods;

CREATE TABLE `deposit_methods` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` bigint NOT NULL,
  `minimum_amount` decimal(10,2) NOT NULL,
  `maximum_amount` decimal(10,2) NOT NULL,
  `fixed_charge` decimal(10,2) NOT NULL,
  `charge_in_percentage` decimal(10,2) NOT NULL,
  `descriptions` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint NOT NULL DEFAULT '1',
  `requirements` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS deposit_requests;

CREATE TABLE `deposit_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_id` bigint unsigned NOT NULL,
  `method_id` bigint unsigned NOT NULL,
  `credit_account_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `converted_amount` decimal(10,2) NOT NULL,
  `charge` decimal(10,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `requirements` text COLLATE utf8mb4_unicode_ci,
  `attachment` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `transaction_id` bigint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deposit_requests_member_id_foreign` (`member_id`),
  KEY `deposit_requests_method_id_foreign` (`method_id`),
  KEY `deposit_requests_credit_account_id_foreign` (`credit_account_id`),
  CONSTRAINT `deposit_requests_credit_account_id_foreign` FOREIGN KEY (`credit_account_id`) REFERENCES `savings_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `deposit_requests_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE,
  CONSTRAINT `deposit_requests_method_id_foreign` FOREIGN KEY (`method_id`) REFERENCES `deposit_methods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS email_sms_templates;

CREATE TABLE `email_sms_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci,
  `sms_body` text COLLATE utf8mb4_unicode_ci,
  `notification_body` text COLLATE utf8mb4_unicode_ci,
  `shortcode` text COLLATE utf8mb4_unicode_ci,
  `email_status` tinyint NOT NULL DEFAULT '0',
  `sms_status` tinyint NOT NULL DEFAULT '0',
  `notification_status` tinyint NOT NULL DEFAULT '0',
  `template_mode` tinyint NOT NULL DEFAULT '0' COMMENT '0 = all, 1 = email, 2 = sms, 3 = notification',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO email_sms_templates VALUES('1','Transfer Money','TRANSFER_MONEY','Transfer Money','<div>
<div>Dear {{name}},</div>
<div>You have received {{amount}} to {{account_number}} from {{sender_account_number}} on {{dateTime}}</div>
</div>','Dear {{name}}, You have received {{amount}} to {{account_number}} from {{sender_account_number}} on {{dateTime}}','Dear {{name}}, You have received {{amount}} to {{account_number}} from {{sender_account_number}} on {{dateTime}}','{{name}} {{account_number}} {{amount}} {{sender}} {{sender_account_number}} {{balance}} {{dateTime}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('2','Deposit Money','DEPOSIT_MONEY','Deposit Money','<div>
<div>Dear {{name}},</div>
<div>Your account has been credited with {{amount}} on {{dateTime}}</div>
</div>','Dear {{name}}, Your account has been credited with {{amount}} on {{dateTime}}','Dear {{name}}, Your account has been credited with {{amount}} on {{dateTime}}','{{name}} {{account_number}} {{amount}} {{dateTime}} {{balance}} {{depositMethod}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('3','Deposit Request Approved','DEPOSIT_REQUEST_APPROVED','Deposit Request Approved','<div>
<div>Dear {{name}},</div>
<div>Your deposit request has been approved. Your account {{account_number}} has been credited with {{amount}} on {{dateTime}}</div>
</div>','Dear {{name}}, Your deposit request has been approved. Your account {{account_number}} has been credited with {{amount}} on {{dateTime}}','Dear {{name}}, Your deposit request has been approved. Your account {{account_number}} has been credited with {{amount}} on {{dateTime}}','{{name}} {{account_number}} {{amount}} {{dateTime}} {{balance}} {{depositMethod}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('4','Loan Request Approved','LOAN_REQUEST_APPROVED','Loan Request Approved','<div>
<div>Dear {{name}},</div>
<div>Your loan request of {{amount}} has been approved on {{dateTime}}</div>
</div>','Dear {{name}}, Your loan request of {{amount}} has been approved on {{dateTime}}','Dear {{name}}, Your loan request of {{amount}} has been approved on {{dateTime}}','{{name}} {{amount}} {{dateTime}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('5','Withdraw Request Approved','WITHDRAW_REQUEST_APPROVED','Withdraw Request Approved','<div>
<div>Dear {{name}},</div>
<div>Your withdraw request has been approved. Your account has been debited with {{amount}} on {{dateTime}}</div>
</div>','Dear {{name}}, Your withdraw request has been approved. Your account has been debited with {{amount}} on {{dateTime}}','Dear {{name}}, Your withdraw request has been approved. Your account has been debited with {{amount}} on {{dateTime}}','{{name}} {{account_number}} {{amount}} {{withdrawMethod}} {{balance}} {{dateTime}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('6','Deposit Request Rejected','DEPOSIT_REQUEST_REJECTED','Deposit Request Rejected','<div>
<div>Dear {{name}},</div>
<div>Your deposit request of {{amount}} has been rejected.</div>
<div>&nbsp;</div>
<div>Amount:&nbsp;{{amount}}</div>
<div>Deposit Method: {{depositMethod}}</div>
</div>','Dear {{name}}, Your deposit request of {{amount}} has been rejected.','Dear {{name}}, Your deposit request of {{amount}} has been rejected.','{{name}}  {{account_number}} {{amount}} {{depositMethod}} {{balance}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('7','Loan Request Rejected','LOAN_REQUEST_REJECTED','Loan Request Rejected','<div>
<div>Dear {{name}},</div>
<div>Your loan request of {{amount}} has been rejected on {{dateTime}}</div>
</div>','Dear {{name}}, Your loan request of {{amount}} has been rejected on {{dateTime}}','Dear {{name}}, Your loan request of {{amount}} has been rejected on {{dateTime}}','{{name}} {{amount}} {{dateTime}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('8','Withdraw Request Rejected','WITHDRAW_REQUEST_REJECTED','Withdraw Request Rejected','<div>
<div>Dear {{name}}, Your withdraw request has been rejected. Your transferred amount {{amount}} has returned back to your account.</div>
</div>','Dear {{name}}, Your withdraw request has been rejected. Your transferred amount {{amount}} has returned back to your account.','Dear {{name}}, Your withdraw request has been rejected. Your transferred amount {{amount}} has returned back to your account.','{{name}} {{account_number}} {{amount}} {{withdrawMethod}} {{dateTime}} {{balance}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('9','Withdraw Money','WITHDRAW_MONEY','Withdraw Money','<div>
<div>Dear {{name}},</div>
<div>Your account has been debited with {{amount}} on {{dateTime}}</div>
</div>','Dear {{name}}, Your account has been debited with {{amount}} on {{dateTime}}','Dear {{name}}, Your account has been debited with {{amount}} on {{dateTime}}','{{name}} {{account_number}} {{amount}} {{dateTime}} {{withdrawMethod}} {{balance}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('10','Member Request Accepted','MEMBER_REQUEST_ACCEPTED','Member Request Accepted','<div>
<div>Dear {{name}},</div>
<div>Your member request has been accepted by authority on {{dateTime}}. You can now login to your account by using your email and password.</div>
</div>','','','{{name}} {{member_no}} {{dateTime}}','0','0','0','1','','');
INSERT INTO email_sms_templates VALUES('11','Loan Payment Received','LOAN_PAYMENT_RECEIVED','Loan Payment Received Confirmation','<p>Dear <strong>{{name}}</strong>,</p> <p>We have successfully received your loan payment of <strong>{{amount}}</strong> on <strong>{{dateTime}}</strong>. Thank you for your payment.</p> <p><strong>Payment Details:</strong></p> <ul> <li><strong>Loan ID:</strong> {{loanID}}</li> <li><strong>Payment Amount:</strong> {{amount}}</li> <li><strong>Payment Date:</strong> {{dateTime}}</li> <li><strong>Next Due Date:</strong> {{nextDueDate}}</li></ul>','Dear {{name}}, We have successfully received your loan payment of {{amount}} on {{dateTime}}. Thank you for your payment.','Dear {{name}}, We have successfully received your loan payment of {{amount}} on {{dateTime}}. Thank you for your payment.','{{name}} {{amount}} {{loanID}} {{nextDueDate}} {{dateTime}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('12','Overdue Loan Payment','OVERDUE_LOAN_PAYMENT','Overdue Loan Payment Alert','<p>Dear <strong>{{name}}</strong>,</p> <p>We regret to inform you that your loan account has entered default status due to non-payment. Your loan payment of <strong>{{dueAmount}}</strong> was due on <strong>{{dueDate}}</strong>, and despite our previous reminders, we have not received the payment. Immediate action is required to prevent further consequences, including additional fees or legal actions.</p> <p><strong>Loan Details:</strong></p> <ul> <li><strong>Loan ID:</strong> {{loanID}}</li> <li><strong>Default Amount:</strong> {{dueAmount}}</li> <li><strong>Number of Due:</strong> {{numberOfDue}}</li> <li><strong>Due Date:</strong> {{dueDate}}</li> </ul> <p>We urge you to make the payment immediately or contact us to discuss your options. Failure to resolve this matter may result in additional penalties or legal actions.</p>','Dear {{name}}, your loan account has entered default due to non-payment of {{dueAmount}}. Please make the payment immediately to avoid further consequences. Loan ID: {{loanID}}. Due Date: {{dueDate}}.','Dear {{name}}, your loan account has entered default due to non-payment of {{dueAmount}}. Please make the payment immediately to avoid further consequences. Loan ID: {{loanID}}. Due Date: {{dueDate}}.','{{name}} {{dueAmount}} {{numberOfDue}} {{loanID}} {{dueDate}}','0','0','0','0','','');
INSERT INTO email_sms_templates VALUES('13','Upcoming Loan Payment Reminder','UPCOMING_LOAN_PAYMENT_REMINDER','Upcoming Loan Payment Reminder','<p>Dear <strong>{{name}}</strong>,</p> <p>This is a friendly reminder that your next loan payment of <strong>{{amount}}</strong> for Loan ID <strong>{{loanID}}</strong> is due on <strong>{{dueDate}}</strong>. Please ensure timely payment to avoid any penalties.</p> <p><strong>Payment Details:</strong></p> <ul> <li><strong>Loan ID:</strong> {{loanID}}</li> <li><strong>Payment Amount:</strong> {{amount}}</li> <li><strong>Due Date:</strong> {{dueDate}}</li></ul> <p>If you have any questions, feel free to contact us at <a href=\'mailto:support@company.com\'>support@company.com</a>.</p>','Dear {{name}}, your next loan payment of {{amount}} for Loan ID {{loanID}} is due on {{dueDate}}. Please make the payment on time to avoid penalties.','Dear {{name}}, your next loan payment of {{amount}} for Loan ID {{loanID}} is due on {{dueDate}}. Please make the payment on time to avoid penalties.','{{name}} {{amount}} {{loanID}} {{dueDate}}','0','0','0','0','','');



DROP TABLE IF EXISTS expense_categories;

CREATE TABLE `expense_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS expenses;

CREATE TABLE `expenses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `expense_date` datetime NOT NULL,
  `expense_category_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `reference` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `attachment` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_user_id` bigint DEFAULT NULL,
  `updated_user_id` bigint DEFAULT NULL,
  `branch_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_expense_category_id_foreign` (`expense_category_id`),
  KEY `expenses_branch_id_foreign` (`branch_id`),
  CONSTRAINT `expenses_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL,
  CONSTRAINT `expenses_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS failed_jobs;

CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS guarantors;

CREATE TABLE `guarantors` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `loan_id` bigint unsigned NOT NULL,
  `member_id` bigint unsigned NOT NULL,
  `savings_account_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `guarantors_loan_id_foreign` (`loan_id`),
  KEY `guarantors_member_id_foreign` (`member_id`),
  CONSTRAINT `guarantors_loan_id_foreign` FOREIGN KEY (`loan_id`) REFERENCES `loans` (`id`) ON DELETE CASCADE,
  CONSTRAINT `guarantors_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS interest_posting;

CREATE TABLE `interest_posting` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_type_id` bigint NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS loan_collaterals;

CREATE TABLE `loan_collaterals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `loan_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `collateral_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serial_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimated_price` decimal(10,2) NOT NULL,
  `attachments` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `loan_collaterals_loan_id_foreign` (`loan_id`),
  CONSTRAINT `loan_collaterals_loan_id_foreign` FOREIGN KEY (`loan_id`) REFERENCES `loans` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS loan_payments;

CREATE TABLE `loan_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `loan_id` bigint unsigned NOT NULL,
  `paid_at` date NOT NULL,
  `late_penalties` decimal(10,2) NOT NULL,
  `interest` decimal(10,2) NOT NULL,
  `repayment_amount` decimal(10,2) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci,
  `member_id` bigint unsigned NOT NULL,
  `transaction_id` bigint DEFAULT NULL,
  `repayment_id` bigint NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `loan_payments_loan_id_foreign` (`loan_id`),
  KEY `loan_payments_member_id_foreign` (`member_id`),
  CONSTRAINT `loan_payments_loan_id_foreign` FOREIGN KEY (`loan_id`) REFERENCES `loans` (`id`) ON DELETE CASCADE,
  CONSTRAINT `loan_payments_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS loan_products;

CREATE TABLE `loan_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `loan_id_prefix` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `starting_loan_id` bigint DEFAULT NULL,
  `minimum_amount` decimal(10,2) NOT NULL,
  `maximum_amount` decimal(10,2) NOT NULL,
  `late_payment_penalties` decimal(10,2) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `interest_rate` decimal(10,2) NOT NULL,
  `interest_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `term` int NOT NULL,
  `term_period` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `loan_application_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `loan_application_fee_type` tinyint NOT NULL DEFAULT '0' COMMENT '0 = Fixed | 1 = Percentage',
  `loan_processing_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `loan_processing_fee_type` tinyint NOT NULL DEFAULT '0' COMMENT '0 = Fixed | 1 = Percentage',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO loan_products VALUES('1','Basic Loan','BL','1','5000.00','2000000.00','4.00','','5.00','flat_rate','2','+1 year','1','6000.00','0','10000.00','0','2025-05-18 09:23:38','2025-05-18 09:23:38');



DROP TABLE IF EXISTS loan_repayments;

CREATE TABLE `loan_repayments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `loan_id` bigint NOT NULL,
  `repayment_date` date NOT NULL,
  `amount_to_pay` decimal(10,2) NOT NULL,
  `penalty` decimal(10,2) NOT NULL,
  `principal_amount` decimal(10,2) NOT NULL,
  `interest` decimal(10,2) NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `upcomming_notification` timestamp NULL DEFAULT NULL,
  `overdue_notification` timestamp NULL DEFAULT NULL,
  `final_notification` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS loans;

CREATE TABLE `loans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `loan_id` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `loan_product_id` bigint unsigned NOT NULL,
  `borrower_id` bigint unsigned NOT NULL,
  `debit_account_id` bigint unsigned DEFAULT NULL,
  `first_payment_date` date NOT NULL,
  `release_date` date DEFAULT NULL,
  `currency_id` bigint NOT NULL,
  `applied_amount` decimal(10,2) NOT NULL,
  `total_payable` decimal(10,2) DEFAULT NULL,
  `total_paid` decimal(10,2) DEFAULT NULL,
  `late_payment_penalties` decimal(10,2) NOT NULL,
  `attachment` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `remarks` text COLLATE utf8mb4_unicode_ci,
  `status` int NOT NULL DEFAULT '0',
  `disburse_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cash',
  `approved_date` date DEFAULT NULL,
  `approved_user_id` bigint DEFAULT NULL,
  `created_user_id` bigint DEFAULT NULL,
  `updated_user_id` bigint DEFAULT NULL,
  `branch_id` bigint DEFAULT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS member_documents;

CREATE TABLE `member_documents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `document` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `member_documents_member_id_foreign` (`member_id`),
  CONSTRAINT `member_documents_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS members;

CREATE TABLE `members` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `member_no` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `credit_source` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO members VALUES('1','Chiweme','Msiska','','4','1','msiskac23@gmail.com','265','994896571','','20251001','male','Blantyre','Blantyre','','','Saving','default.png','[]','2025-05-18 09:12:09','2025-05-18 09:16:31');



DROP TABLE IF EXISTS migrations;

CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES('1','2014_10_12_000000_create_users_table','1');
INSERT INTO migrations VALUES('2','2014_10_12_100000_create_password_resets_table','1');
INSERT INTO migrations VALUES('3','2019_08_19_000000_create_failed_jobs_table','1');
INSERT INTO migrations VALUES('4','2019_09_01_080940_create_settings_table','1');
INSERT INTO migrations VALUES('5','2019_12_14_000001_create_personal_access_tokens_table','1');
INSERT INTO migrations VALUES('6','2020_07_02_145857_create_database_backups_table','1');
INSERT INTO migrations VALUES('7','2020_07_06_142817_create_roles_table','1');
INSERT INTO migrations VALUES('8','2020_07_06_143240_create_permissions_table','1');
INSERT INTO migrations VALUES('9','2021_03_22_071324_create_setting_translations','1');
INSERT INTO migrations VALUES('10','2021_07_02_145504_create_pages_table','1');
INSERT INTO migrations VALUES('11','2021_07_02_145952_create_page_translations_table','1');
INSERT INTO migrations VALUES('12','2021_08_06_104648_create_branches_table','1');
INSERT INTO migrations VALUES('13','2021_08_07_111236_create_currency_table','1');
INSERT INTO migrations VALUES('14','2021_08_08_132702_create_payment_gateways_table','1');
INSERT INTO migrations VALUES('15','2021_08_08_152535_create_deposit_methods_table','1');
INSERT INTO migrations VALUES('16','2021_08_08_164152_create_withdraw_methods_table','1');
INSERT INTO migrations VALUES('17','2021_08_31_201125_create_navigations_table','1');
INSERT INTO migrations VALUES('18','2021_08_31_201126_create_navigation_items_table','1');
INSERT INTO migrations VALUES('19','2021_08_31_201127_create_navigation_item_translations_table','1');
INSERT INTO migrations VALUES('20','2021_10_22_070458_create_email_sms_templates_table','1');
INSERT INTO migrations VALUES('21','2022_03_21_075342_create_members_table','1');
INSERT INTO migrations VALUES('22','2022_03_24_090932_create_member_documents_table','1');
INSERT INTO migrations VALUES('23','2022_03_28_114203_create_savings_products_table','1');
INSERT INTO migrations VALUES('24','2022_04_13_073108_create_savings_accounts_table','1');
INSERT INTO migrations VALUES('25','2022_04_13_073109_create_transactions_table','1');
INSERT INTO migrations VALUES('26','2022_05_31_074804_create_expense_categories_table','1');
INSERT INTO migrations VALUES('27','2022_05_31_074918_create_expenses_table','1');
INSERT INTO migrations VALUES('28','2022_06_01_082019_create_loan_products_table','1');
INSERT INTO migrations VALUES('29','2022_06_01_083021_create_loans_table','1');
INSERT INTO migrations VALUES('30','2022_06_01_083022_create_loan_collaterals_table','1');
INSERT INTO migrations VALUES('31','2022_06_01_083025_create_loan_payments_table','1');
INSERT INTO migrations VALUES('32','2022_06_01_083069_create_loan_repayments_table','1');
INSERT INTO migrations VALUES('33','2022_06_06_072245_create_guarantors_table','1');
INSERT INTO migrations VALUES('34','2022_07_26_155338_create_deposit_requests_table','1');
INSERT INTO migrations VALUES('35','2022_07_26_163427_create_withdraw_requests_table','1');
INSERT INTO migrations VALUES('36','2022_08_09_160105_create_notifications_table','1');
INSERT INTO migrations VALUES('37','2022_08_15_055625_create_interest_posting_table','1');
INSERT INTO migrations VALUES('38','2022_08_27_151317_create_transaction_categories_table','1');
INSERT INTO migrations VALUES('39','2022_08_29_102757_create_schedule_tasks_histories_table','1');
INSERT INTO migrations VALUES('40','2022_09_13_162539_add_branch_id_to_users_table','1');
INSERT INTO migrations VALUES('41','2022_09_18_074806_add_branch_id_to_expenses_table','1');
INSERT INTO migrations VALUES('42','2022_10_16_081858_add_charge_to_deposit_requests_table','1');
INSERT INTO migrations VALUES('43','2022_10_29_095023_add_status_to_members_table','1');
INSERT INTO migrations VALUES('44','2023_01_29_093731_create_charge_limits_table','1');
INSERT INTO migrations VALUES('45','2024_02_18_171623_add_auto_account_number_to_savings_products_table','1');
INSERT INTO migrations VALUES('46','2024_05_10_205624_add_starting_loan_id_to_loan_products_table','1');
INSERT INTO migrations VALUES('47','2024_05_11_175920_create_custom_fields_table','1');
INSERT INTO migrations VALUES('48','2024_05_15_183254_add_custom_fields_to_loans_table','1');
INSERT INTO migrations VALUES('49','2024_05_15_201559_add_2fa_columns_to_users_table','1');
INSERT INTO migrations VALUES('50','2024_09_09_171047_add_loan_application_fee_to_loan_products_table','1');
INSERT INTO migrations VALUES('51','2025_02_01_201958_add_auto_account_creation_to_savings_products_table','1');
INSERT INTO migrations VALUES('52','2025_02_03_033823_add_all_branch_access_to_users_table','1');
INSERT INTO migrations VALUES('53','2025_02_05_233619_add_notification_column_to_loan_repayments_table','1');
INSERT INTO migrations VALUES('54','2025_02_07_200733_add_loan_disburse_method_to_loans_table','1');
INSERT INTO migrations VALUES('55','2025_02_07_220334_create_bank_accounts_table','1');
INSERT INTO migrations VALUES('56','2025_02_07_220344_create_bank_transactions_table','1');



DROP TABLE IF EXISTS navigation_item_translations;

CREATE TABLE `navigation_item_translations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `navigation_item_id` bigint unsigned NOT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `navigation_item_translations_navigation_item_id_locale_unique` (`navigation_item_id`,`locale`),
  CONSTRAINT `navigation_item_translations_navigation_item_id_foreign` FOREIGN KEY (`navigation_item_id`) REFERENCES `navigation_items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS navigation_items;

CREATE TABLE `navigation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `navigation_id` bigint unsigned NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `page_id` bigint unsigned DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned DEFAULT NULL,
  `position` int unsigned DEFAULT NULL,
  `status` tinyint(1) NOT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `navigation_items_parent_id_foreign` (`parent_id`),
  KEY `navigation_items_page_id_foreign` (`page_id`),
  KEY `navigation_items_navigation_id_index` (`navigation_id`),
  CONSTRAINT `navigation_items_navigation_id_foreign` FOREIGN KEY (`navigation_id`) REFERENCES `navigations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `navigation_items_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `pages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `navigation_items_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `navigation_items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS navigations;

CREATE TABLE `navigations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS notifications;

CREATE TABLE `notifications` (
  `id` char(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS page_translations;

CREATE TABLE `page_translations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `page_id` bigint unsigned NOT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_translations_page_id_locale_unique` (`page_id`,`locale`),
  CONSTRAINT `page_translations_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS pages;

CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pages_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS password_resets;

CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS payment_gateways;

CREATE TABLE `payment_gateways` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `is_crypto` tinyint NOT NULL DEFAULT '0',
  `parameters` text COLLATE utf8mb4_unicode_ci,
  `currency` varchar(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_currencies` text COLLATE utf8mb4_unicode_ci,
  `extra` text COLLATE utf8mb4_unicode_ci,
  `exchange_rate` decimal(10,6) DEFAULT NULL,
  `fixed_charge` decimal(10,2) NOT NULL DEFAULT '0.00',
  `charge_in_percentage` decimal(10,2) NOT NULL DEFAULT '0.00',
  `minimum_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `maximum_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_gateways VALUES('1','PayPal','PayPal','paypal.png','0','0','{\"client_id\":\"\",\"client_secret\":\"\",\"environment\":\"sandbox\"}','','{\"AUD\":\"AUD\",\"BRL\":\"BRL\",\"CAD\":\"CAD\",\"CZK\":\"CZK\",\"DKK\":\"DKK\",\"EUR\":\"EUR\",\"HKD\":\"HKD\",\"HUF\":\"HUF\",\"INR\":\"INR\",\"ILS\":\"ILS\",\"JPY\":\"JPY\",\"MYR\":\"MYR\",\"MXN\":\"MXN\",\"TWD\":\"TWD\",\"NZD\":\"NZD\",\"NOK\":\"NOK\",\"PHP\":\"PHP\",\"PLN\":\"PLN\",\"GBP\":\"GBP\",\"RUB\":\"RUB\",\"SGD\":\"SGD\",\"SEK\":\"SEK\",\"CHF\":\"CHF\",\"THB\":\"THB\",\"USD\":\"USD\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('2','Stripe','Stripe','stripe.png','0','0','{\"secret_key\":\"\",\"publishable_key\":\"\"}','','{\"USD\":\"USD\",\"AUD\":\"AUD\",\"BRL\":\"BRL\",\"CAD\":\"CAD\",\"CHF\":\"CHF\",\"DKK\":\"DKK\",\"EUR\":\"EUR\",\"GBP\":\"GBP\",\"HKD\":\"HKD\",\"INR\":\"INR\",\"JPY\":\"JPY\",\"MXN\":\"MXN\",\"MYR\":\"MYR\",\"NOK\":\"NOK\",\"NZD\":\"NZD\",\"PLN\":\"PLN\",\"SEK\":\"SEK\",\"SGD\":\"SGD\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('3','Razorpay','Razorpay','razorpay.png','0','0','{\"razorpay_key_id\":\"\",\"razorpay_key_secret\":\"\"}','','{\"INR\":\"INR\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('4','Paystack','Paystack','paystack.png','0','0','{\"paystack_public_key\":\"\",\"paystack_secret_key\":\"\"}','','{\"GHS\":\"GHS\",\"NGN\":\"NGN\",\"ZAR\":\"ZAR\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('5','Flutterwave','Flutterwave','flutterwave.png','0','0','{\"public_key\":\"\",\"secret_key\":\"\",\"encryption_key\":\"\",\"environment\":\"sandbox\"}','','{\"BIF\":\"BIF\",\"CAD\":\"CAD\",\"CDF\":\"CDF\",\"CVE\":\"CVE\",\"EUR\":\"EUR\",\"GBP\":\"GBP\",\"GHS\":\"GHS\",\"GMD\":\"GMD\",\"GNF\":\"GNF\",\"KES\":\"KES\",\"LRD\":\"LRD\",\"MWK\":\"MWK\",\"MZN\":\"MZN\",\"NGN\":\"NGN\",\"RWF\":\"RWF\",\"SLL\":\"SLL\",\"STD\":\"STD\",\"TZS\":\"TZS\",\"UGX\":\"UGX\",\"USD\":\"USD\",\"XAF\":\"XAF\",\"XOF\":\"XOF\",\"ZMK\":\"ZMK\",\"ZMW\":\"ZMW\",\"ZWD\":\"ZWD\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('6','VoguePay','VoguePay','VoguePay.png','1','0','{\"merchant_id\":\"\"}','','{\"USD\":\"USD\",\"GBP\":\"GBP\",\"EUR\":\"EUR\",\"GHS\":\"GHS\",\"NGN\":\"NGN\",\"ZAR\":\"ZAR\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('7','Mollie','Mollie','Mollie.png','1','0','{\"api_key\":\"\"}','','{\"AED\":\"AED\",\"AUD\":\"AUD\",\"BGN\":\"BGN\",\"BRL\":\"BRL\",\"CAD\":\"CAD\",\"CHF\":\"CHF\",\"CZK\":\"CZK\",\"DKK\":\"DKK\",\"EUR\":\"EUR\",\"GBP\":\"GBP\",\"HKD\":\"HKD\",\"HRK\":\"HRK\",\"HUF\":\"HUF\",\"ILS\":\"ILS\",\"ISK\":\"ISK\",\"JPY\":\"JPY\",\"MXN\":\"MXN\",\"MYR\":\"MYR\",\"NOK\":\"NOK\",\"NZD\":\"NZD\",\"PHP\":\"PHP\",\"PLN\":\"PLN\",\"RON\":\"RON\",\"RUB\":\"RUB\",\"SEK\":\"SEK\",\"SGD\":\"SGD\",\"THB\":\"THB\",\"TWD\":\"TWD\",\"USD\":\"USD\",\"ZAR\":\"ZAR\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('8','CoinPayments','CoinPayments','CoinPayments.png','1','1','{\"public_key\":\"\",\"private_key\":\"\",\"merchant_id\":\"\",\"ipn_secret\":\"\"}','','{\"BTC\":\"Bitcoin\",\"BTC.LN\":\"Bitcoin (Lightning Network)\",\"LTC\":\"Litecoin\",\"CPS\":\"CPS Coin\",\"VLX\":\"Velas\",\"APL\":\"Apollo\",\"AYA\":\"Aryacoin\",\"BAD\":\"Badcoin\",\"BCD\":\"Bitcoin Diamond\",\"BCH\":\"Bitcoin Cash\",\"BCN\":\"Bytecoin\",\"BEAM\":\"BEAM\",\"BITB\":\"Bean Cash\",\"BLK\":\"BlackCoin\",\"BSV\":\"Bitcoin SV\",\"BTAD\":\"Bitcoin Adult\",\"BTG\":\"Bitcoin Gold\",\"BTT\":\"BitTorrent\",\"CLOAK\":\"CloakCoin\",\"CLUB\":\"ClubCoin\",\"CRW\":\"Crown\",\"CRYP\":\"CrypticCoin\",\"CRYT\":\"CryTrExCoin\",\"CURE\":\"CureCoin\",\"DASH\":\"DASH\",\"DCR\":\"Decred\",\"DEV\":\"DeviantCoin\",\"DGB\":\"DigiByte\",\"DOGE\":\"Dogecoin\",\"EBST\":\"eBoost\",\"EOS\":\"EOS\",\"ETC\":\"Ether Classic\",\"ETH\":\"Ethereum\",\"ETN\":\"Electroneum\",\"EUNO\":\"EUNO\",\"EXP\":\"EXP\",\"Expanse\":\"Expanse\",\"FLASH\":\"FLASH\",\"GAME\":\"GameCredits\",\"GLC\":\"Goldcoin\",\"GRS\":\"Groestlcoin\",\"KMD\":\"Komodo\",\"LOKI\":\"LOKI\",\"LSK\":\"LSK\",\"MAID\":\"MaidSafeCoin\",\"MUE\":\"MonetaryUnit\",\"NAV\":\"NAV Coin\",\"NEO\":\"NEO\",\"NMC\":\"Namecoin\",\"NVST\":\"NVO Token\",\"NXT\":\"NXT\",\"OMNI\":\"OMNI\",\"PINK\":\"PinkCoin\",\"PIVX\":\"PIVX\",\"POT\":\"PotCoin\",\"PPC\":\"Peercoin\",\"PROC\":\"ProCurrency\",\"PURA\":\"PURA\",\"QTUM\":\"QTUM\",\"RES\":\"Resistance\",\"RVN\":\"Ravencoin\",\"RVR\":\"RevolutionVR\",\"SBD\":\"Steem Dollars\",\"SMART\":\"SmartCash\",\"SOXAX\":\"SOXAX\",\"STEEM\":\"STEEM\",\"STRAT\":\"STRAT\",\"SYS\":\"Syscoin\",\"TPAY\":\"TokenPay\",\"TRIGGERS\":\"Triggers\",\"TRX\":\" TRON\",\"UBQ\":\"Ubiq\",\"UNIT\":\"UniversalCurrency\",\"USDT\":\"Tether USD (Omni Layer)\",\"VTC\":\"Vertcoin\",\"WAVES\":\"Waves\",\"XEM\":\"NEM\",\"XMR\":\"Monero\",\"XSN\":\"Stakenet\",\"XSR\":\"SucreCoin\",\"XVG\":\"VERGE\",\"XZC\":\"ZCoin\",\"ZEC\":\"ZCash\",\"ZEN\":\"Horizen\"}','','','0.00','0.00','0.00','0.00','','');
INSERT INTO payment_gateways VALUES('9','Instamojo','Instamojo','instamojo.png','1','0','{\"api_key\":\"\",\"auth_token\":\"\",\"salt\":\"\",\"environment\":\"sandbox\"}','','{\"INR\":\"INR\"}','','','0.00','0.00','0.00','0.00','','');



DROP TABLE IF EXISTS permissions;

CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `role_id` bigint NOT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=181 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('1','3','dashboard.total_customer_widget','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('2','3','dashboard.deposit_requests_widget','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('3','3','dashboard.withdraw_requests_widget','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('4','3','dashboard.loan_requests_widget','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('5','3','dashboard.expense_overview_widget','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('6','3','dashboard.deposit_withdraw_analytics','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('7','3','dashboard.recent_transaction_widget','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('8','3','dashboard.due_loan_list','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('9','3','dashboard.active_loan_balances','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('10','3','members.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('11','3','members.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('12','3','member_documents.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('13','3','savings_accounts.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('14','3','savings_accounts.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('15','3','interest_calculation.calculator','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('16','3','transactions.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('17','3','transactions.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('18','3','deposit_requests.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('19','3','deposit_requests.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('20','3','withdraw_requests.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('21','3','withdraw_requests.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('22','3','expenses.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('23','3','expenses.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('24','3','loans.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('25','3','loans.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('26','3','loan_collaterals.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('27','3','loan_collaterals.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('28','3','loan_payments.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('29','3','loan_payments.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('30','3','bank_accounts.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('31','3','bank_accounts.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('32','3','bank_transactions.index','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('33','3','bank_transactions.show','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('34','3','reports.account_statement','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('35','3','reports.account_balances','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('36','3','reports.transactions_report','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('37','3','reports.loan_report','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('38','3','reports.loan_due_report','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('39','3','reports.loan_repayment_report','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('40','3','reports.expense_report','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('41','3','reports.cash_in_hand','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('42','3','reports.bank_transactions','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('43','3','reports.bank_balances','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('44','3','reports.revenue_report','2025-05-18 12:53:29','2025-05-18 12:53:29');
INSERT INTO permissions VALUES('45','2','dashboard.total_customer_widget','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('46','2','dashboard.deposit_requests_widget','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('47','2','dashboard.withdraw_requests_widget','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('48','2','dashboard.loan_requests_widget','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('49','2','dashboard.expense_overview_widget','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('50','2','dashboard.deposit_withdraw_analytics','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('51','2','dashboard.recent_transaction_widget','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('52','2','dashboard.due_loan_list','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('53','2','dashboard.active_loan_balances','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('54','2','members.accept_request','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('55','2','members.reject_request','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('56','2','members.pending_requests','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('57','2','members.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('58','2','members.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('59','2','member_documents.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('60','2','member_documents.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('61','2','savings_accounts.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('62','2','savings_accounts.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('63','2','savings_accounts.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('64','2','interest_calculation.calculator','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('65','2','interest_calculation.interest_posting','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('66','2','transactions.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('67','2','transactions.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('68','2','transactions.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('69','2','deposit_requests.approve','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('70','2','deposit_requests.reject','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('71','2','deposit_requests.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('72','2','deposit_requests.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('73','2','withdraw_requests.approve','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('74','2','withdraw_requests.reject','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('75','2','withdraw_requests.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('76','2','withdraw_requests.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('77','2','expenses.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('78','2','expenses.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('79','2','expenses.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('80','2','loans.upcoming_loan_repayments','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('81','2','loans.admin_calculator','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('82','2','loans.calculate','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('83','2','loans.approve','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('84','2','loans.reject','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('85','2','loans.filter','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('86','2','loans.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('87','2','loans.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('88','2','loans.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('89','2','loan_collaterals.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('90','2','loan_collaterals.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('91','2','loan_collaterals.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('92','2','guarantors.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('93','2','loan_payments.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('94','2','loan_payments.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('95','2','bank_accounts.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('96','2','bank_accounts.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('97','2','bank_accounts.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('98','2','bank_transactions.index','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('99','2','bank_transactions.show','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('100','2','bank_transactions.edit','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('101','2','reports.account_statement','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('102','2','reports.account_balances','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('103','2','reports.transactions_report','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('104','2','reports.loan_report','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('105','2','reports.loan_due_report','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('106','2','reports.loan_repayment_report','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('107','2','reports.expense_report','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('108','2','reports.cash_in_hand','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('109','2','reports.bank_transactions','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('110','2','reports.bank_balances','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('111','2','reports.revenue_report','2025-05-18 12:56:04','2025-05-18 12:56:04');
INSERT INTO permissions VALUES('112','1','dashboard.total_customer_widget','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('113','1','dashboard.deposit_requests_widget','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('114','1','dashboard.withdraw_requests_widget','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('115','1','dashboard.loan_requests_widget','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('116','1','dashboard.expense_overview_widget','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('117','1','dashboard.deposit_withdraw_analytics','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('118','1','dashboard.recent_transaction_widget','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('119','1','dashboard.due_loan_list','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('120','1','dashboard.active_loan_balances','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('121','1','members.import','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('122','1','members.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('123','1','members.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('124','1','members.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('125','1','members.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('126','1','member_documents.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('127','1','member_documents.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('128','1','member_documents.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('129','1','savings_accounts.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('130','1','savings_accounts.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('131','1','savings_accounts.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('132','1','savings_accounts.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('133','1','interest_calculation.calculator','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('134','1','interest_calculation.interest_posting','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('135','1','transactions.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('136','1','transactions.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('137','1','transactions.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('138','1','transactions.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('139','1','deposit_requests.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('140','1','deposit_requests.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('141','1','withdraw_requests.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('142','1','withdraw_requests.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('143','1','expenses.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('144','1','expenses.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('145','1','expenses.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('146','1','expenses.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('147','1','loans.upcoming_loan_repayments','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('148','1','loans.admin_calculator','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('149','1','loans.calculate','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('150','1','loans.filter','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('151','1','loans.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('152','1','loans.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('153','1','loans.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('154','1','loans.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('155','1','loan_collaterals.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('156','1','loan_collaterals.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('157','1','loan_collaterals.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('158','1','loan_collaterals.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('159','1','guarantors.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('160','1','guarantors.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('161','1','loan_payments.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('162','1','loan_payments.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('163','1','loan_payments.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('164','1','bank_accounts.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('165','1','bank_accounts.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('166','1','bank_accounts.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('167','1','bank_accounts.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('168','1','bank_transactions.index','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('169','1','bank_transactions.create','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('170','1','bank_transactions.show','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('171','1','bank_transactions.edit','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('172','1','reports.account_statement','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('173','1','reports.account_balances','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('174','1','reports.transactions_report','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('175','1','reports.loan_report','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('176','1','reports.loan_due_report','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('177','1','reports.loan_repayment_report','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('178','1','reports.expense_report','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('179','1','reports.cash_in_hand','2025-05-18 12:57:55','2025-05-18 12:57:55');
INSERT INTO permissions VALUES('180','1','reports.bank_transactions','2025-05-18 12:57:55','2025-05-18 12:57:55');



DROP TABLE IF EXISTS personal_access_tokens;

CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS roles;

CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES('1','Capturer','This role is used to capture all the loan details including borrower information and documents.','2025-05-18 08:50:33','2025-05-18 08:50:33');
INSERT INTO roles VALUES('2','Approver','This role is used to approve loans and other operational tasks.','2025-05-18 08:51:03','2025-05-18 08:51:03');
INSERT INTO roles VALUES('3','Viewer','This role can only view information.','2025-05-18 08:51:23','2025-05-18 08:51:23');



DROP TABLE IF EXISTS savings_accounts;

CREATE TABLE `savings_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_number` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `member_id` bigint unsigned NOT NULL,
  `savings_product_id` bigint unsigned NOT NULL,
  `status` int NOT NULL COMMENT '1 = action | 2 = Deactivate',
  `opening_balance` decimal(10,2) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_user_id` bigint DEFAULT NULL,
  `updated_user_id` bigint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `savings_accounts_member_id_foreign` (`member_id`),
  KEY `savings_accounts_savings_product_id_foreign` (`savings_product_id`),
  CONSTRAINT `savings_accounts_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE,
  CONSTRAINT `savings_accounts_savings_product_id_foreign` FOREIGN KEY (`savings_product_id`) REFERENCES `savings_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS savings_products;

CREATE TABLE `savings_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number_prefix` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `starting_account_number` bigint DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `interest_rate` decimal(8,2) DEFAULT NULL,
  `interest_method` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `interest_period` int DEFAULT NULL,
  `interest_posting_period` int DEFAULT NULL,
  `min_bal_interest_rate` decimal(10,2) DEFAULT NULL,
  `allow_withdraw` tinyint NOT NULL DEFAULT '1',
  `minimum_account_balance` decimal(10,2) NOT NULL DEFAULT '0.00',
  `minimum_deposit_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `maintenance_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `maintenance_fee_posting_period` int DEFAULT NULL,
  `auto_create` tinyint NOT NULL DEFAULT '0',
  `status` int NOT NULL COMMENT '1 = active | 2 = Deactivate',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `savings_products_currency_id_foreign` (`currency_id`),
  CONSTRAINT `savings_products_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS schedule_tasks_histories;

CREATE TABLE `schedule_tasks_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint DEFAULT NULL,
  `others` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS setting_translations;

CREATE TABLE `setting_translations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `setting_id` bigint unsigned NOT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_translations_setting_id_locale_unique` (`setting_id`,`locale`),
  CONSTRAINT `setting_translations_setting_id_foreign` FOREIGN KEY (`setting_id`) REFERENCES `settings` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS settings;

CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO settings VALUES('1','mail_type','sendmail','','2025-05-18 09:13:26');
INSERT INTO settings VALUES('2','backend_direction','ltr','','');
INSERT INTO settings VALUES('3','language','English','','');
INSERT INTO settings VALUES('4','email_verification','disabled','','');
INSERT INTO settings VALUES('5','allow_singup','yes','','');
INSERT INTO settings VALUES('6','starting_member_no','20251002','','2025-05-18 09:12:09');
INSERT INTO settings VALUES('7','company_name','Kingdom Financial Services','2025-05-18 06:34:45','2025-05-18 06:34:45');
INSERT INTO settings VALUES('8','site_title','Kingdom Financial Services','2025-05-18 06:34:45','2025-05-18 06:34:45');
INSERT INTO settings VALUES('9','phone','+265994896571','2025-05-18 06:34:45','2025-05-18 06:34:45');
INSERT INTO settings VALUES('10','email','info@kingdomfinancialservices.com','2025-05-18 06:34:45','2025-05-18 06:34:45');
INSERT INTO settings VALUES('11','timezone','Africa/Blantyre','2025-05-18 06:34:45','2025-05-18 06:34:45');
INSERT INTO settings VALUES('12','from_email','noreply@cadecommh.org','2025-05-18 08:39:20','2025-05-18 09:13:26');
INSERT INTO settings VALUES('13','from_name','Kingdom Financial Services','2025-05-18 08:39:20','2025-05-18 09:13:26');
INSERT INTO settings VALUES('14','smtp_host','mail.cadecommh.org','2025-05-18 08:39:20','2025-05-18 09:13:26');
INSERT INTO settings VALUES('15','smtp_port','465','2025-05-18 08:39:20','2025-05-18 09:13:26');
INSERT INTO settings VALUES('16','smtp_username','noreply@cadecommh.org','2025-05-18 08:39:20','2025-05-18 09:13:26');
INSERT INTO settings VALUES('17','smtp_password','Rly:Bv;f&x','2025-05-18 08:39:20','2025-05-18 09:13:26');
INSERT INTO settings VALUES('18','smtp_encryption','ssl','2025-05-18 08:39:20','2025-05-18 09:13:26');
INSERT INTO settings VALUES('19','logo','logo.png','2025-05-18 09:02:59','2025-05-18 09:02:59');
INSERT INTO settings VALUES('20','favicon','file_1747573383.png','2025-05-18 09:03:03','2025-05-18 09:03:03');



DROP TABLE IF EXISTS transaction_categories;

CREATE TABLE `transaction_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `related_to` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL DEFAULT '1',
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS transactions;

CREATE TABLE `transactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_id` bigint unsigned NOT NULL,
  `trans_date` datetime NOT NULL,
  `savings_account_id` bigint unsigned DEFAULT NULL,
  `charge` decimal(10,2) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `gateway_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `dr_cr` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `method` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `loan_id` bigint DEFAULT NULL,
  `ref_id` bigint DEFAULT NULL,
  `parent_id` bigint unsigned DEFAULT NULL COMMENT 'Parent transaction id',
  `gateway_id` bigint DEFAULT NULL COMMENT 'PayPal | Stripe | Other Gateway',
  `created_user_id` bigint DEFAULT NULL,
  `updated_user_id` bigint DEFAULT NULL,
  `branch_id` bigint DEFAULT NULL,
  `transaction_details` text COLLATE utf8mb4_unicode_ci,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_member_id_foreign` (`member_id`),
  KEY `transactions_savings_account_id_foreign` (`savings_account_id`),
  KEY `transactions_parent_id_foreign` (`parent_id`),
  CONSTRAINT `transactions_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_savings_account_id_foreign` FOREIGN KEY (`savings_account_id`) REFERENCES `savings_accounts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `role_id` bigint DEFAULT NULL,
  `branch_id` bigint unsigned DEFAULT NULL,
  `status` int NOT NULL,
  `profile_picture` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `all_branch_access` tinyint NOT NULL DEFAULT '0',
  `two_factor_code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_expires_at` datetime DEFAULT NULL,
  `two_factor_code_count` int NOT NULL DEFAULT '0',
  `otp` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otp_expires_at` datetime DEFAULT NULL,
  `otp_count` int NOT NULL DEFAULT '0',
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `users_branch_id_foreign` (`branch_id`),
  CONSTRAINT `users_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES('1','Chiweme','msiskac23@gmail.com','admin','','','1','default.png','2025-05-18 06:33:59','$2y$10$mzX5AaC.t1QZF7wM47nX2.hTUtflNFxfyNfXn9o8tvGueC/SiuxTW','0','','','0','','','0','','','y9jB0tzCkwyL67nPLm4w8yAQcQiTxPYzdkpS4GtNZPk5B290di9lv95HQvsv','2025-05-18 06:33:59','2025-05-18 06:33:59');
INSERT INTO users VALUES('2','Joanna Gausi','Joanna.gausi@gmail.com','user','2','','1','default.png','2025-05-18 08:41:26','$2y$10$3XPxXpQo3d9LD.epvtVsR.eGifBekdvb52rWRgiHmZIiNSz8Qv3Ci','0','','','0','','','0','','','','2025-05-18 08:41:26','2025-05-18 09:17:31');
INSERT INTO users VALUES('3','Chiweme Msiska','chiweme.msiska@nicotechnologies.com','user','1','','1','default.png','2025-05-18 09:01:46','$2y$10$8N2jwFblJtr1mdALpM3UUOsEOGNp5XarHQ5FnKGc7bljy5rv329au','0','','','0','','','0','','','','2025-05-18 09:01:46','2025-05-18 09:01:46');
INSERT INTO users VALUES('4','Chiweme','member+msiskac23@gmail.com','customer','','','1','','','$2y$10$Eb2xkeZSPu0U30V.oF4/BewDAqA11kxRof5sQ.HXukmxlnz7SUmui','0','','','0','','','0','','','','2025-05-18 09:16:31','2025-05-18 09:16:31');



DROP TABLE IF EXISTS withdraw_methods;

CREATE TABLE `withdraw_methods` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` bigint NOT NULL,
  `minimum_amount` decimal(10,2) NOT NULL,
  `maximum_amount` decimal(10,2) NOT NULL,
  `fixed_charge` decimal(10,2) NOT NULL,
  `charge_in_percentage` decimal(10,2) NOT NULL,
  `descriptions` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint NOT NULL DEFAULT '1',
  `requirements` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO withdraw_methods VALUES('1','Cash Withdrawal','default.png','1','0.00','0.00','0.00','0.00','','1','null','2025-05-18 08:49:23','2025-05-18 08:49:23');



DROP TABLE IF EXISTS withdraw_requests;

CREATE TABLE `withdraw_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `member_id` bigint unsigned NOT NULL,
  `method_id` bigint unsigned NOT NULL,
  `debit_account_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `converted_amount` decimal(10,2) NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `requirements` text COLLATE utf8mb4_unicode_ci,
  `attachment` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `transaction_id` bigint DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `withdraw_requests_member_id_foreign` (`member_id`),
  KEY `withdraw_requests_method_id_foreign` (`method_id`),
  KEY `withdraw_requests_debit_account_id_foreign` (`debit_account_id`),
  CONSTRAINT `withdraw_requests_debit_account_id_foreign` FOREIGN KEY (`debit_account_id`) REFERENCES `savings_accounts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `withdraw_requests_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `members` (`id`) ON DELETE CASCADE,
  CONSTRAINT `withdraw_requests_method_id_foreign` FOREIGN KEY (`method_id`) REFERENCES `withdraw_methods` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




